CREATE TABLE subjects (
  subject_id int(6) NOT NULL default '0',
  subject_term varchar(255) NOT NULL default '',
  subject_note text NOT NULL,
  PRIMARY KEY  (subject_id),
) TYPE=MyISAM;


CREATE TABLE items4authors (
  author_id int(6) default NULL,
  article_id int(6) default NULL
) TYPE=MyISAM;


CREATE TABLE items4subjects (
  subject_id int(6) NOT NULL default '0',
  article_id int(6) NOT NULL default '0'
) TYPE=MyISAM;


CREATE TABLE authors (
  author_id int(6) NOT NULL default '0',
  first_name varchar(255) default NULL,
  middle_name varchar(255) default NULL,
  last_name varchar(255) default NULL,
  email varchar(255) default NULL,
  url varchar(255) default NULL,
  PRIMARY KEY  (author_id)
) TYPE=MyISAM;


CREATE TABLE templates (
  template_id int(6) NOT NULL default '0',
  template_name varchar(255) default NULL,
  template_content text,
  PRIMARY KEY  (template_id)
) TYPE=MyISAM;


CREATE TABLE articles (
	article_id int(6) NOT NULL default '0',
	article_title varchar(255) default NULL,
	article_changes text,
	article_content text,
	article_contributor varchar(255) default NULL,
	article_date date default '0000-00-00',
	article_note text,
	article_path varchar(255) default NULL,
	article_filename varchar(255) default NULL,
	article_source varchar(255) default NULL,
	template_id int(6) default '0',
	stylesheet_id int(6) default '0',
	PRIMARY KEY (article_id)
) TYPE=MyISAM;


CREATE TABLE sequence (
  id int(6) NOT NULL default '0'
) TYPE=MyISAM;
INSERT INTO sequence (id) values ('1');


CREATE TABLE stylesheets (
  stylesheet_id int(6) NOT NULL default '0',
  stylesheet_name varchar(255) NOT NULL default '',
  stylesheet_note text NOT NULL,
  stylesheet_content text,
  PRIMARY KEY  (stylesheet_id),
) TYPE=MyISAM;


