#!/usr/bin/perl

# templates.cgi - a Web interface for managing Musings templates

# Eric Lease Morgan <eric_morgan@infomotions.com>

# 2004-11-03 - first cust


# require the necessary modules
use lib '../lib';
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);
use Musings::Template;
use strict;
require 'subroutines.pl';

# initialize two global variables
my $cgi = CGI->new;
my $html;

# branch according to the input
if (! $cgi->param('cmd')) { &home }
elsif ($cgi->param('cmd') eq 'create')  { &create }
elsif ($cgi->param('cmd') eq 'find') { &find }
elsif ($cgi->param('cmd') eq 'edit')    { &edit }
elsif ($cgi->param('cmd') eq 'delete')  { &delete }
else { $html = $cgi->p("Unknown command. Call Eric") }

# quit
&gracefulExit;


sub home {

	# build a simple home page
	$html  = $cgi->h1('Manage templates');
	$html .= $cgi->p('Use this script to create, edit, and delete Musings templates.');

}


sub create {

	# initialize the output
	$html = $cgi->h1('Create');
	
	# branch according to the input
	if (! $cgi->param('button')) {
		
		# build the form
		$html .= $cgi->p('Use this form to create a template.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'create');
		$html .= table({-border => 0}, Tr({-align => 'left', -valign => 'top'},
						[
							th(['Item', 'Value']),
							td(['Name', $cgi->textfield(-name => 'name')]),
							td(['Content', $cgi->textarea(-name => 'content', -rows => 12, -columns => 50)]),
							td([''    , $cgi->submit(-name => 'button', -value => 'Create')])
						]
					)
				 );
		$html .= $cgi->endform;
    
    }
    
    else {
    
    	# create an object, fill it, and save
    	my $template = Musings::Template->new;
    	$template->template_name($cgi->param('name'));
    	$template->template_content($cgi->param('content'));
		$template->commit;
				
		# echo the results
		$html .= $cgi->p('Template created:');
		$html .= $cgi->ul(li('ID -', $template->template_id),
		                  li('Name - ', $template->template_name),
		                  li('Content - ', $cgi->pre(&escape($template->template_content)))
		                 );
    
    }
    
}


sub find {

	# initialize the output
	$html  = $cgi->h1('All templates');
	$html .= $cgi->p('This is a list of all the templates:');
	
	# get all the templates, build a list, and display it
	my @templates = Musings::Template->get_templates();
	my $items;
	foreach (@templates) { $items .= $cgi->li($_->template_name, ' (' . $_->template_id . ')') }
	$html .= $cgi->ul($items);
	
}


sub edit {

	# initialize the output and a button
	$html = $cgi->h1('Edit templates');
	my $submit .= $cgi->submit(-name => 'button', -value => 'Edit');
	
	# branch according to the input
	if (! $cgi->param('button')) {
	
		# create a hash of templates; needs to be sorted
		my @templates = Musings::Template->get_templates();
		my %templates;
		foreach (@templates) { $templates{$_->template_id} = $_->template_name }
	
		# display a form
		$html .= $cgi->p('Select a template to edit');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'edit');
		$html .= $cgi->popup_menu(-name => 'id', -values => \%templates);
		$html .= $submit;			 
		$html .= $cgi->endform;

	}
	
	elsif (! $cgi->param('name') || ! $cgi->param('content')) {
	
    	# create an object based on the input, and create form parts
    	my $template = Musings::Template->new(id => $cgi->param('id'));
    	
		# display an edit form
		$html .= $cgi->p('Use this form to edit a template.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'edit');
		$html .= $cgi->hidden(-name => 'id', -value => $template->template_id);
		$html .= table({-border => 0},
					Tr({-align => 'left', -valign => 'top'},
						[
							th(['Item', 'Value']),
							td(['ID'  , $template->template_id]),
							td(['Name', $cgi->textfield(-name => 'name', -value => $template->template_name)]),
							td(['Content', $cgi->textarea(-name => 'content', -value => $template->template_content, -rows => 12, -columns => 50)]),
							td([''    , $submit])
						]
					)
				 );
		$html .= $cgi->endform;
    
    }
    
	else {

		# create and object, fill it, and save
		my $template = Musings::Template->new(id => $cgi->param('id'));
		$template->template_name($cgi->param('name'));
		$template->template_content($cgi->param('content'));
		$template->commit;
		
		# echo the result
		$html .= $cgi->p('Template updated.');
		$html .= $cgi->p('ID:', $template->template_id, '<br />Name:', $template->template_name, '<br />Content:' , $cgi->pre(&escape($template->template_content)));
    
    }

}


sub delete {

	# initialize the output
	$html = $cgi->h1('Delete templates');
	
	# branch according to the input
	if (! $cgi->param('button')) {
	
		# build of hash of all templates; needs to be sorted
		my @templates = Musings::Template->get_templates();
		my %templates;
		foreach (@templates) { $templates{$_->template_id} = $_->template_name }

		# display a pop-up list of templates
		$html .= $cgi->p('Select a template to delete:');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'delete');
		$html .= $cgi->popup_menu(-name => 'id', -values => \%templates);
		$html .= $cgi->submit(-name => 'button', -value => 'delete', -label => 'Delete');		 
		$html .= $cgi->endform;

	}
	
	elsif ($cgi->param('button') eq 'Delete') {
    
    	# create an object based on input
    	my $template = Musings::Template->new(id => $cgi->param('id'));
    	
		# display a confirmation
		$html .= $cgi->p('Are you sure you want to delete the template named <b>' . $template->template_name . '</b>?');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'delete');
		$html .= $cgi->hidden(-name => 'id', -value => $template->template_id);
		$html .= $cgi->submit(-name => 'button', -value => 'yes', -label => 'Yes');
		$html .= ' ';
		$html .= $cgi->submit(-name => 'button', -value => 'no', -label => 'No');		 
		$html .= $cgi->endform;
    
    }
    
    elsif ($cgi->param('button') eq 'Yes') {
    
    	# delete the template; do the work and echo the result
    	my $template = Musings::Template->new(id => $cgi->param('id'));
    	$template->delete;
    	$html .= $cgi->p('The template ' . $template->template_name . ' has been deleted.');
    
    }
    
    elsif ($cgi->param('button') eq 'No') {
    
    	# abort
    	my $template = Musings::Template->new(id => $cgi->param('id'));
    	$html .= $cgi->p('The template ' . $template->template_name . ' has <b>not</b> been deleted.');

    }
    
}


sub gracefulExit {

	# output the 'magic line', a standard header, the content, and a standard footer, then done
	print $cgi->header;
	print &header;
	print $html;
	print &footer;
	exit;

}


sub header {

	# get the value of this script
	my $script = $cgi->script_name;
	
	# return a standard html page; notice the stylesheet
	return <<EOH;
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Manage templates</title>
		<link rel='stylesheet' href='style.css' type='text/css' />
	</head>
	<body>
		<div id="navcontainer">
			<ul id="navlist">
				<li><a href="home.cgi">Home</a></li>
				<li><a href="authors.cgi">Authors</a></li>
				<li><a href="subjects.cgi">Subjects</a></li>
				<li><a href="templates.cgi" id="current">Templates</a></li>
				<li><a href="stylesheets.cgi">Stylesheets</a></li>
				<li><a href="articles.cgi">Articles</a></li>
			</ul>
		</div>
	
		<div class='menu'>
			<p><b><a href="$script">Manage templates</a></b></p>
			<a href="$script?cmd=create">Create</a><br />
			<a href="$script?cmd=find">Find</a><br />
			<a href="$script?cmd=edit">Edit</a><br />
			<a href="$script?cmd=delete">Delete</a><br />
			<br />
		</div>
		
		<div class='content'>
EOH

}
