#!/usr/bin/perl

# define
use constant WIDTH => 40;

# include
use strict;

# get input
my $book    = $ARGV[ 0 ];
my $pattern = $ARGV[ 1 ];
if ( ! $book or ! $pattern ) {

	print "Usage: $0 <file> <regular expression>\n";
	exit;
	
}

# slurp
open ( F, " < $book" ) or die "Can't open book: $!\n";
my $text = '';
while ( <F> ) { $text .= $_ }
close F;

# clean
$text =~ s/\n/ /g;
$text =~ s/ +/ /g;

# display
my $width = WIDTH;
while ( $text =~ m/(.{0,$width}$pattern.{0,$width})/ig ) { print "$1\n" }
