<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- plain ol' text; get rid of some white space -->
	<xsl:output method='text'/>
	<xsl:strip-space elements='*'/>
	
	<!-- let's get started -->
	<xsl:template match="/letter">

		<!-- add a line-feed for formatting's sake -->
		<xsl:text>&#xa;</xsl:text>	

		<!-- do the work -->
		<xsl:apply-templates/>
							
	</xsl:template>
	
	
	<!-- trap all the various elements -->
	
	<xsl:template match='date | address_two | greeting | paragraph | closing'>
		<xsl:value-of select='normalize-space(.)'/>
		<xsl:text>&#xa;&#xa;</xsl:text>	
	</xsl:template>
	

	<xsl:template match='name | address_one'>
		<xsl:value-of select='normalize-space(.)'/>
		<xsl:text>&#xa;</xsl:text>	
	</xsl:template>
	

	<xsl:template match='list'>
		<xsl:apply-templates/>
		<xsl:text>&#xa;</xsl:text>
	</xsl:template>
	

	<xsl:template match='item'>

		<!-- insert a tab, an asterisk, and a space for formatting -->
		<xsl:text>&#x9;*&#x20;</xsl:text>
		<xsl:value-of select='normalize-space(.)'/>
		<xsl:text>&#xa;</xsl:text>
	</xsl:template>
	
</xsl:stylesheet>
