sub same_breath {

	return <<JAVASCRIPT;
<div style='float: right;border-width: 2px; border-style: dashed; border-color: white;'>
	<script type="text/javascript+protovis">
	
		var w = 550,
			h = 550;
		
		var vis = new pv.Panel()
			.width(w)
			.height(h)
			.fillStyle("white")
			.event("mousedown", pv.Behavior.pan())
			.event("mousewheel", pv.Behavior.zoom());
		
		var force = vis.add(pv.Layout.Force)
			.nodes(corpus.nodes)
			.links(corpus.links)
			.springLength(50)
			.chargeConstant(-1750)
			.bound(true);
			
		force.link.add(pv.Line);
		
		force.node.add(pv.Dot)
			.size(function(d) (d.linkDegree + 175) * Math.pow(this.scale, -1.5))
			.lineWidth(.5)
			.fillStyle("pink")
			.title(function(d) d.nodeName)
			.event("mousedown", pv.Behavior.drag())
			.event("drag", force);
		
		force.label.add(pv.Label).font('14px sans-serif');
		
		vis.render();
	
	</script>
</div>
JAVASCRIPT

}


sub notfound {

	$html = qq(<html><head><title>Bummer!</title></head><body style='text-align: center; margin: 20%'><h1>Bummer!</h1><p>That word is not in the book. <a href="./">Please try another</a>.</p></body></html>);
	print "Content-Type: text/html; charset=ISO-8859-1\n\n";
	print $html;
	exit;

}


sub coocurances {

	my $query = shift;
	my $words = shift;
	my $threshold = shift;
	
	my $t = 0;
	my %coocurrances = ();
	
	foreach ( sort { $$words{ $b } <=> $$words{ $a } } keys %$words ) {
	
		$coocurrances{ $_ } = $$words{ $_ };
		$t++;
		last if ( $t == $threshold );
		
	}
	
	return \%coocurrances;

}


sub concordance {

	my $corpus    = shift;
	my $query     = shift;
	my $radius    = shift;
	my $stopwords = shift;
	
	my $subset = '';
	my $concordance = Lingua::Concordance->new;
	$concordance->text( $corpus );
	$concordance->query( $query );
	$concordance->radius( $radius );
	foreach ( $concordance->lines ) { $subset .= $_ . ' ' }
	if ( ! $subset ) { &notfound }
	$subset =~ tr/a-zA-Zà-ƶÀ-Ƶ'()\-,.?!;:/\n/cs;
	$subset =~ s/([,.?!:;()\-])/\n$1\n/g;
	$subset =~ s/\n+/\n/g;
	my @tokens = split /\n/, lc( $subset );
	my %words = ();
	foreach ( @tokens ) {
	
		next if ( $_ =~ /[,.?!:;()\-]/ );
		next if ( $$stopwords{ $_ } );
		next if ( length( $_ ) < 3 );
		$words{ $_ }++;
	
	}

	return \%words;
	
}


sub slurp {

	# open a file named by the input and return its contents
	my $f = @_[0];
	open (F, "< $f");
	my $r = do { local $/; <F> };
	close F;
	return $r;

}



1;